/*	Copyright 2002 by Eric Postpischil, http://edp.org.
	See license information in index.html.
*/


#include	"StdAfx.h"
#include	"resource.h"

#include	<commctrl.h>


// Message handler for About box.
BOOL CALLBACK	About(HWND dialog, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
			return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
			{
				EndDialog(dialog, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}


/*	Message handler for Options box.
	This dialog is passed an OptionsDialogInfo structure.
	The options member contains the old options and is
	filled with the new options by this routine.
	IDOK or IDCANCEL is returned.
*/
BOOL CALLBACK	Options(HWND dialog, UINT message, WPARAM wParam, LPARAM lParam)
{
	/*	On creation, we are passed a pointer to space allocated for us.
		On subsequent calls, we use our saved copy of that pointer.
	*/
	OptionsDialogInfo	* const info = (OptionsDialogInfo *) (message == WM_INITDIALOG
		? lParam : GetWindowLong(dialog, GWL_USERDATA));


	/*	Ignore whatever the dialog procedure is doing before we
		are initialized.
	*/
	if (info == NULL && message != WM_INITDIALOG)
		return FALSE;

	switch (message)
	{
		case WM_INITDIALOG:
			// Save pointer passed to us at creation for future calls.
			SetWindowLong(dialog, GWL_USERDATA, (LONG) info);

			// Initialize controls.

			/*	The thickness edit box is limited to one digit, and
				the spin control ranges from 9 to 0.
			*/
			SendDlgItemMessage(dialog, IDC_PERIMETERTHICKNESS, EM_SETLIMITTEXT, 1, 0);
			SendDlgItemMessage(dialog, IDC_PERIMETERTHICKNESS, EM_LIMITTEXT, 1, 0);
			SendDlgItemMessage(dialog, IDC_PERIMETERSPIN, UDM_SETRANGE, 0,
				MAKELONG(9, 0));

			// Set controls to match current options.
			SetDlgItemInt(dialog, IDC_PERIMETERTHICKNESS,
				info->options.perimeterPenPixels, FALSE);
			CheckRadioButton(dialog, IDC_PERIMETERWHITE, IDC_PERIMETERBLACK,
				info->options.perimeterPenColor == RGB(0, 0, 0) ?
					IDC_PERIMETERBLACK : IDC_PERIMETERWHITE);
			CheckDlgButton(dialog, IDC_INTERIORLINES, info->options.interiorPen);

			// Locate IDC_SAMPLE and create display window there.
			{
				HWND	frame;
				RECT	rect;
				POINT	point;


				// Locate sample frame and find coordinates relative to dialog.
				frame = GetDlgItem(dialog, IDC_SAMPLE);
				GetWindowRect(frame, &rect);
				point.x = rect.left;
				point.y = rect.top;
				ScreenToClient(dialog, &point);

				// Get width and height.
				rect.right -= rect.left;
				rect.bottom -= rect.top;

				// Create TriDisplay window over sample area.
				info->sampleWindow = CreateWindow("TriDisplay", NULL,
					WS_CHILDWINDOW | WS_VISIBLE,
					point.x, point.y, rect.right, rect.bottom,
					dialog, (HMENU) IDC_SAMPLE,
					(HINSTANCE) GetWindowLong(dialog, GWL_HINSTANCE),
					&info->sampleInfo);
			}

			// Set display options and sample shape.
			SendMessage(info->sampleWindow, WM_SETOPTIONS, 0, (LPARAM) &info->options);
			SendMessage(info->sampleWindow, WM_SETSHAPE, MAKELONG(0, CE_REDRAW),
				(LPARAM) sampleShape());

			return TRUE;

		case WM_COMMAND:
			switch (LOWORD(wParam))
			{
				case IDOK:
				case IDCANCEL:
					// Return IDOK or IDCANCEL.
					EndDialog(dialog, LOWORD(wParam));
					return TRUE;

				case IDC_PERIMETERTHICKNESS:
					switch (HIWORD(wParam))
					{
						case EN_CHANGE:
							// Set number of pixels in perimeter pen.
							info->options.perimeterPenPixels = GetDlgItemInt(dialog,
								IDC_PERIMETERTHICKNESS, NULL, FALSE);
							// Update sample display.
							SendMessage(info->sampleWindow, WM_SETOPTIONS,
								0, (LPARAM) &info->options);
							// Turn color selection off when pen is null (0 pixels).
							EnableWindow(GetDlgItem(dialog, IDC_PERIMETERBLACK),
								info->options.perimeterPenPixels != 0);
							EnableWindow(GetDlgItem(dialog, IDC_PERIMETERWHITE),
								info->options.perimeterPenPixels != 0);
							return TRUE;
					}
					return FALSE;

				case IDC_PERIMETERWHITE:
					// Set perimeter pen to white and update sample display.
					info->options.perimeterPenColor = RGB(255, 255, 255);
					SendMessage(info->sampleWindow, WM_SETOPTIONS,
						0, (LPARAM) &info->options);
					return TRUE;

				case IDC_PERIMETERBLACK:
					// Set perimeter pen to black and update sample display.
					info->options.perimeterPenColor = RGB(0, 0, 0);
					SendMessage(info->sampleWindow, WM_SETOPTIONS,
						0, (LPARAM) &info->options);
					return TRUE;

				case IDC_INTERIORLINES:
					// Turn interior lines on or off and update sample display.
					info->options.interiorPen =
						IsDlgButtonChecked(dialog, IDC_INTERIORLINES);
					SendMessage(info->sampleWindow, WM_SETOPTIONS,
						0, (LPARAM) &info->options);
					return TRUE;
			}
			break;
	}
    return FALSE;
}


/*	Message handler for Zoom To box.
	This dialog gets a zoom percentage from the user.
	Return value is a percentage or zero to cancel.
*/
BOOL CALLBACK	ZoomTo(HWND dialog, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
			// The edit box is limited to three digits and we begin at 100%.
			SendDlgItemMessage(dialog, IDC_ZOOMTO, EM_SETLIMITTEXT, 3, 0);
			SendDlgItemMessage(dialog, IDC_ZOOMTO, EM_LIMITTEXT, 3, 0);
			SetDlgItemInt(dialog, IDC_ZOOMTO, 100, FALSE);
			return TRUE;

		case WM_COMMAND:
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					int	percentage;


					/*	On okay, return selected percentage.  But if it
						is zero, beep and refuse to close.
					*/
					percentage = GetWindowLong(dialog, GWL_USERDATA);
					if (0 < percentage)
						EndDialog(dialog, percentage);
					else
						MessageBeep(MB_OK);
					return TRUE;
				}

				case IDCANCEL:
					// On cancel, return zero to mean no change.
					EndDialog(dialog, 0);
					return TRUE;

				case IDC_ZOOMTO:
					switch (HIWORD(wParam))
					{
						case EN_CHANGE:
							// Remember the number the user selects.
							SetWindowLong(dialog, GWL_USERDATA,
								GetDlgItemInt(dialog, IDC_ZOOMTO, NULL, FALSE));
							return TRUE;
					}
					return FALSE;
			}
			break;
	}
    return FALSE;
}